import 'dart:convert';
import 'dart:io';

import 'package:viserpay/core/utils/method.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/authorization/authorization_response_model.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/model/kyc/kyc_response_model.dart';
import 'package:viserpay/data/model/nominee/nominee_create_response.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:http/http.dart' as http;

class NomineeRepo {
  ApiClient apiClient;
  NomineeRepo({required this.apiClient});

  Future<ResponseModel> getNomineeForm() async {
    final response = await apiClient.request(UrlContainer.savingsNomineeForm, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<ResponseModel> deleteNominee({
    required String nomineeId,
    required String pin,
  }) async {
    final response = await apiClient.request(UrlContainer.savingsNomineeDelete, Method.postMethod, {'nominee_id': nomineeId, 'pin': pin}, passHeader: true);
    return response;
  }

  Future<ResponseModel> getNomineeList() async {
    final response = await apiClient.request(UrlContainer.savingsNomineeList, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<NomineeCreateResponseModel> addNewNominee({
    required List<FormModel> list,
    required String birthDate,
    required String name,
    required File nomineeImage,
  }) async {
    apiClient.initToken();

    try {
      await modelToMap(list);
      var request = http.MultipartRequest('POST', Uri.parse(UrlContainer.savingsNomineeCreate));

      Map<String, String> finalMap = {
        'birth_date': birthDate,
        'name': name,
      };

      for (var element in fieldList) {
        finalMap.addAll(element);
      }

      request.headers.addAll(<String, String>{'Authorization': 'Bearer ${apiClient.token}'});

      request.files.add(http.MultipartFile('image', nomineeImage.readAsBytes().asStream(), nomineeImage.lengthSync(), filename: nomineeImage.path.split('/').last));

      for (var file in filesList) {
        request.files.add(http.MultipartFile(file.key ?? '', file.value.readAsBytes().asStream(), file.value.lengthSync(), filename: file.value.path.split('/').last));
      }

      request.fields.addAll(finalMap);
      http.StreamedResponse response = await request.send();
      String jsonResponse = await response.stream.bytesToString();

      printX('-------${UrlContainer.savingsNomineeCreate.toString()}');
      printX('-----response: ${jsonResponse.toString()}');
      NomineeCreateResponseModel model = NomineeCreateResponseModel.fromJson(jsonDecode(jsonResponse));
      return model;
    } catch (e) {
      printX('---------${e.toString()}');
      return NomineeCreateResponseModel(remark: 'error', status: 'error');
    }
  }

  List<Map<String, String>> fieldList = [];
  List<ModelDynamicValue> filesList = [];

  Future<dynamic> modelToMap(List<FormModel> list) async {
    for (var e in list) {
      if (e.type == 'checkbox') {
        if (e.cbSelected != null && e.cbSelected!.isNotEmpty) {
          for (int i = 0; i < e.cbSelected!.length; i++) {
            fieldList.add({'${e.label}[$i]': e.cbSelected![i]});
          }
        }
      } else if (e.type == 'file') {
        if (e.imageFile != null) {
          filesList.add(ModelDynamicValue(e.label, e.imageFile!));
        }
      } else {
        if (e.selectedValue != null && e.selectedValue.toString().isNotEmpty) {
          fieldList.add({e.label ?? '': e.selectedValue});
        }
      }
    }
  }
}

class ModelDynamicValue {
  String? key;
  dynamic value;
  ModelDynamicValue(this.key, this.value);
}
